echo off

rem Sample test script for satellite tuner

rem	 -i    Tuner type; valid values are: c (cable), s (satellite)
rem	       t (Terrestrial DVB) and a (Terrestrial ATSC)
rem	 -f    Frequency (Transponder) in MHz (c, s); e.g. 350
rem	 -s    Symbol Rate in Ks/s (c, s); e.g. 6111
rem	 -m    Modulation in QAM (c); valid values are:
rem	       4, 16, 32, 64, 128, 256
rem	 -l    LNB Frequency in MHz (s); note: must be less than Transponder
rem	       Frequency specified with -f
rem	 -e    FEC (s); valid values are:
rem	       1/2, 2/3, 3/4, 5/6, 7/8, auto
rem	 -o    Polarity (s); valid values are: h (horizontal), v (vertical)
rem	 -k    LNB Selection in KHz(s); valid values are: 0, 22, 33, 44
rem	 -d    Diseqc (s); valid values are:
rem	       n (none), a, b, a/a, a/b, b/a, b/b
rem	 -g    Guard Interval (t): valid values are:
rem	 	   1/32, 1/16, 1/8, 1/4, Auto
rem	 -b    Bandwidth (t): valid values are:
rem	 	   6, 7, 8
rem	 -p0   For Filter Pin 0, assign data PID as integer or hex. (c, s); e.g. 164,
rem	       0xa4 or 0XA4.  For multiple data PIDs, specify a separate -p0 option;
rem	       e.g. -p0 17 -p0 18.
rem	 -p1   For Filter Pin 1, assign data PID.
rem	 -p2   For Filter Pin 2, assign data PID.
rem	 -p3   For Filter Pin 3, assign data PID.

rem	 Options:
rem	 -t    Time duration in seconds for dumping to file; default is 10 seconds
rem	 -h    Help


echo on

.\TestDataFilter.exe -i s -f 12384 -s 20000 -l 11250 -e auto -o h -k 0 -d a/a -p0 5666 -p1 5667 -p2 1222 -p3 1223 -t 10
